<?php

namespace App\Http\Controllers;

use App\Models\Client;
use App\Models\Clients;
use App\Models\Transaction;
use Illuminate\Http\Request;

class ClientController extends Controller
{
    public function index()
    {
        $clients = Client::all();

        $modifiedClients = $clients->map(function ($client) {
            return [
                'id' => $client->id,
                'name' => $client->name,
                'phoneNumber' => $client->phone_number,
                'nationalId' => $client->national_id,
                // Add other desired modifications here
            ];
        });

        return response()->json($modifiedClients);
    }

    public function transactions($id)
    {
        $client = Clients::findOrFail($id);
        $transactions = Transaction::where('client_id', $id)
            ->with(['user', 'currency'])
            ->get();

        $totalBought = Transaction::where('client_id', $id)
            ->where('type', 'buy')
            ->sum('total_rwf');
        $totalSold = Transaction::where('client_id', $id)
            ->where('type', 'sell')
            ->sum('total_rwf');
        $buyCount = Transaction::where('client_id', $id)
            ->where('type', 'buy')
            ->count();
        $sellCount = Transaction::where('client_id', $id)
            ->where('type', 'sell')
            ->count();

        return response()->json([
            'client' => [
                'id' => $client->id,
                'name' => $client->name,
                'phoneNumber' => $client->phone_number,
                'nationalId' => $client->national_id
            ],
            'transactions' => $transactions->map(function ($t) {
                return [
                    'id' => $t->id,
                    'userName' => $t->user->name,
                    'currencyCode' => $t->currency->code,
                    'type' => $t->type,
                    'amount' => $t->amount,
                    'rate' => $t->rate,
                    'totalRwf' => $t->total_rwf,
                    'transactionDate' => $t->transaction_date
                ];
            }),
            'analytics' => [
                'totalBought' => $totalBought,
                'totalSold' => $totalSold,
                'buyCount' => $buyCount,
                'sellCount' => $sellCount
            ]
        ]);
    }
}
