<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreCurrencyRequest;
use App\Models\Currency;
use App\Services\CurrencyService;
use Illuminate\Http\Request;

class CurrencyController extends Controller
{
    protected $service;

    public function __construct(CurrencyService $service) {
        $this->service = $service;
    }

    public function index() {
        return response()->json($this->service->index());
    }

    public function store(Request $request) {
        $data = $request->validate([
            'code' => 'required|string|max:3|unique:currencies,code',
            'name' => 'required|string|max:255'
        ]);
        return response()->json($this->service->store($data), 201);
    }

    public function update(Request $request, $id) {
        $data = $request->validate([
            'code' => 'required|string|max:3|unique:currencies,code,' . $id,
            'name' => 'required|string|max:255'
        ]);
        return response()->json($this->service->update($id, $data));
    }

    public function delete($id) {
        return response()->json($this->service->destroy($id));
    }
}
