<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreExchangeRateRequest;
use App\Services\ExchangeRateService;
use Illuminate\Http\Request;

class ExchangeRateController extends Controller
{
    protected $service;

    public function __construct(ExchangeRateService $service) {
        $this->service = $service;
    }

    public function index() {
        $rates = $this->service->index();
        return response()->json($rates);
    }

    public function store(StoreExchangeRateRequest $request) {
        $result = $this->service->store($request->validated());
        return response()->json($result, 201);
    }
}
