<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SellTransactionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize()
    {
        return auth()->user()->role === 'cashier';
    }

    public function rules()
    {
        return [
            'currency_id' => 'required|exists:currencies,id',
            'amount' => 'required|numeric|min:0.01',
            'client.name' => 'sometimes|required|string|max:255',
            'client.phone' => 'nullable|string|max:20',
            'client.email' => 'nullable|email|max:255',
        ];
    }
}
