<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CurrencyStocks extends Model
{
    use HasFactory;

    protected $table = 'currency_stocks';

    protected $fillable = ['currency_id', 'amount', 'buy_price', 'loaded_at'];

    protected $casts = [
        'loaded_at' => 'datetime'
    ];

    public function currency() {
        return $this->belongsTo(Currency::class);
    }
}
