<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ExchangeRate extends Model
{
    use HasFactory;

    protected $table = 'exchange_rates';

    protected $fillable = ['currency_id', 'buy_price', 'sell_price', 'date'];

    protected $casts = [
        'date' => 'datetime'
    ];

    public function currency() {
        return $this->belongsTo(Currency::class);
    }
}
