<?php

namespace App\Services;

use App\Models\Currency;

class CurrencyService
{
    public function index() {
        return Currency::orderBy('code', 'asc')->get();
    }

    public function store(array $data) {
        $currency = Currency::create($data);
        return [
            'message' => 'Currency created successfully',
            'data' => $currency
        ];
    }

    public function update($id, array $data) {
        $currency = Currency::findOrFail($id);
        $currency->update($data);
        return [
            'message' => 'Currency updated successfully',
            'data' => $currency
        ];
    }

    public function destroy($id) {
        $currency = Currency::findOrFail($id);
        $currency->delete();
        return [
            'message' => 'Currency deleted successfully',
            'id' => $id
        ];
    }
}
