<?php

namespace App\Services;

use App\Models\ExchangeRate;

class ExchangeRateService
{
    public function index() {
        return ExchangeRate::with('currency')->get()->map(function ($rate) {
            return [
                'id' => $rate->id,
                'currency_id' => $rate->currency_id,
                'currency_code' => $rate->currency->code,
                'currency_name' => $rate->currency->name,
                'buy_price' => $rate->buy_price,
                'sell_price' => $rate->sell_price,
                'date' => $rate->date,
            ];
        });
    }

    public function store(array $data) {
        $exchangeRate = ExchangeRate::updateOrCreate(
            ['currency_id' => $data['currency_id'], 'date' => $data['date']],
            ['buy_price' => $data['buy_price'], 'sell_price' => $data['sell_price']]
        );
        $exchangeRate->load('currency');
        return [
            'message' => 'Exchange rate updated',
            'data' => [
                'id' => $exchangeRate->id,
                'currency_id' => $exchangeRate->currency_id,
                'currency_code' => $exchangeRate->currency->code,
                'currency_name' => $exchangeRate->currency->name,
                'buy_price' => $exchangeRate->buy_price,
                'sell_price' => $exchangeRate->sell_price,
                'date' => $exchangeRate->date,
            ]
        ];
    }

    public function getTodayRate($currencyId) {
        return ExchangeRate::where('currency_id', $currencyId)
            ->where('date', now()->toDateString())
            ->firstOrFail();
    }
}
