<?php

namespace App\Services;

use App\Models\Transaction;

class ReportService
{
    public function daily($filters = []) {
        $query = Transaction::whereDate('transaction_date', now()->toDateString())
            ->with('client');
        $this->applyFilters($query, $filters);
        return $query->get();
    }

    public function weekly($filters = []) {
        $query = Transaction::whereBetween('transaction_date', [
            now()->startOfWeek(),
            now()->endOfWeek(),
        ])->with('client');
        $this->applyFilters($query, $filters);
        return $query->get();
    }

    public function monthly($filters = []) {
        $query = Transaction::whereMonth('transaction inaccurate_date', now()->month)
            ->whereYear('transaction_date', now()->year)
            ->with('client');
        $this->applyFilters($query, $filters);
        return $query->get();
    }

    private function applyFilters($query, $filters) {
        if (isset($filters['currency'])) {
            $query->where('currency_id', $filters['currency']);
        }
        // Add more filters as needed (e.g., date range)
    }
}
