<?php

namespace App\Services;

use App\Models\CurrencyStocks;
use App\Models\Transaction;

class StockService
{
    public function dailySummary($date) { // $date should be a Carbon instance
        $startOfDay = $date->startOfDay(); // Already a Carbon instance here
        $endOfDay = $date->endOfDay();

        $startingStock = CurrencyStocks::where('loaded_at', '<', $startOfDay)
            ->selectRaw('currency_id, SUM(amount) as amount, buy_price')
            ->groupBy('currency_id', 'buy_price')
            ->get();

        $buys = Transaction::where('type', 'buy')
            ->whereBetween('transaction_date', [$startOfDay, $endOfDay])
            ->selectRaw('currency_id, rate as buy_price, SUM(amount) as amount')
            ->groupBy('currency_id', 'rate')
            ->get();

        $sells = Transaction::where('type', 'sell')
            ->whereBetween('transaction_date', [$startOfDay, $endOfDay])
            ->selectRaw('currency_id, rate as sell_price, SUM(amount) as amount')
            ->groupBy('currency_id', 'rate')
            ->get();

        $endingStock = CurrencyStocks::where('amount', '>', 0)
            ->selectRaw('currency_id, SUM(amount) as amount, buy_price')
            ->groupBy('currency_id', 'buy_price')
            ->get();

        return [
            'starting_stock' => $startingStock->map(fn($s) => [
                'currency_id' => $s->currency_id,
                'amount' => $s->amount,
                'buy_price' => $s->buy_price
            ]),
            'buys' => $buys->map(fn($b) => [
                'currency_id' => $b->currency_id,
                'amount' => $b->amount,
                'buy_price' => $b->buy_price
            ]),
            'sells' => $sells->map(fn($s) => [
                'currency_id' => $s->currency_id,
                'amount' => $s->amount,
                'sell_price' => $s->sell_price
            ]),
            'ending_stock' => $endingStock->map(fn($e) => [
                'currency_id' => $e->currency_id,
                'amount' => $e->amount,
                'buy_price' => $e->buy_price
            ])
        ];
    }
}
