<?php

namespace Database\Seeders;

use App\Models\Currency;
use App\Models\ExchangeRate;
use Illuminate\Database\Seeder;

class ExchangeRateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $currencies = Currency::all();
        foreach ($currencies as $currency) {
            ExchangeRate::updateOrCreate(
                ['currency_id' => $currency->id, 'date' => now()->toDateString()],
                [
                    'buy_price' => $this->getDefaultBuyPrice($currency->code),
                    'sell_price' => $this->getDefaultSellPrice($currency->code),
                ]
            );
        }
    }

    private function getDefaultBuyPrice($code)
    {
        $rates = [
            'RWF' => 1.00, // Base currency
            'USD' => 1300.00,
            'EUR' => 1400.00,
            'GBP' => 1600.00,
            'KES' => 10.00,
        ];
        return $rates[$code] ?? 1.00;
    }

    private function getDefaultSellPrice($code)
    {
        $rates = [
            'RWF' => 1.00, // Base currency
            'USD' => 1320.00,
            'EUR' => 1420.00,
            'GBP' => 1620.00,
            'KES' => 10.50,
        ];
        return $rates[$code] ?? 1.00;
    }
}
