<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Admin User
        User::create([
            'name' => 'Admin User',
            'email' => 'admin@gmail.com',
            'password' => Hash::make('admin123'), // Default password
            'role' => 'admin',
        ]);

        // Cashier User
        User::create([
            'name' => 'Cashier User',
            'email' => 'cashier@gmail.com',
            'password' => Hash::make('cashier123'), // Default password
            'role' => 'cashier',
        ]);
    }
}
