<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\CurrencyController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ExchangeRateController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\StockController;
use App\Http\Controllers\TransactionController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
 */

Route::middleware('auth:sanctum')->group(function () {
    // Admin Routes
    // Route::get('/currencies', [CurrencyController::class, 'index']);
    // Route::post('/currencies', [CurrencyController::class, 'store'])->middleware('role:admin');
    // Route::get('/exchange-rates', [ExchangeRateController::class, 'index']);
    // Route::post('/exchange-rates', [ExchangeRateController::class, 'store'])->middleware('role:admin');

    // // Cashier Routes
    // Route::post('/transactions/buy', [TransactionController::class, 'buy']);
    // Route::post('/transactions/sell', [TransactionController::class, 'sell']);

    // // Reports (accessible to both)
    // Route::get('/reports/daily', [ReportController::class, 'daily']);
    // Route::get('/reports/weekly', [ReportController::class, 'weekly']);
    // Route::get('/reports/monthly', [ReportController::class, 'monthly']);
});

Route::get('/currencies', [CurrencyController::class, 'index']);
Route::post('/currencies', [CurrencyController::class, 'store']);
Route::put('/currencies/{id}', [CurrencyController::class, 'update']);
Route::delete('/currencies/{id}', [CurrencyController::class, 'delete']);
Route::get('/exchange-rates', [ExchangeRateController::class, 'index']);
Route::post('/exchange-rates', [ExchangeRateController::class, 'store']);

// Cashier Routes
Route::get('/transactions', [TransactionController::class, 'index']);
Route::post('/transactions', [TransactionController::class, 'store']);
Route::put('/transactions/{transaction}', [TransactionController::class, 'update']);
Route::get('/transactions/{id}', [TransactionController::class, 'show']);
Route::delete('/transactions/{transaction}', [TransactionController::class, 'destroy']);
Route::get('/exchange-rates/latest', [TransactionController::class, 'getLatestRate']);

Route::get('/dashboard/stats', [DashboardController::class, 'stats']);
Route::get('/dashboard/currency-stocks', [DashboardController::class, 'currencyStocks']);
Route::get('/dashboard/prices', [DashboardController::class, 'prices']);

Route::get('/stock/daily-summary', [StockController::class, 'dailySummary']);

Route::get('/clients', [ClientController::class, 'index']);
Route::get('/clients/{id}/transactions', [ClientController::class, 'transactions']);

Route::get('/stock', [StockController::class, 'index']);

// Reports (accessible to both)
Route::get('/reports/daily', [ReportController::class, 'daily']);

Route::post('/login', [AuthController::class, 'login']);
